%     explicit (iterative) finite difference solution
%        WORKS fine - see if I want to add dimensions and if I want to
%        change it so that the implicit method is solved using the same
%        program.
%     the following data are used:
%     vk = matrix of all potentials
%     v  = vector of potentials at internal nodes
%     n1x= number of divisions in the x direction
%     n1y= number of divisions in the y direction
%     vx1,vx2, boundary potentials on the lower and upper boundaries
%     vy1,vy2, boundary potentials on the left and right boundaries
%     eps, tolerance error per node.
%
%   The program can also place the results in file out1 (see line 35)
%   To do so remove the comments on the statements associated with the file
%   writing
%
% enter data

      n1x=input('enter number of divisions in the x direction  --->  ')
%      write(1,*)'enter number of divisions in the x direction'
      n1y=input('enter number of divisions in the y direction  --->  ')
%      write(1,*)'enter number of divisions in the y direction'
      vx1=input('enter boundary condition on lower boundary  --->  ')
%      write(1,*)'enter boundary condition on lower boundary'
      vx2=input('enter boundary condition on upper boundary  --->  ')
%      write(1,*)'enter boundary condition on upper boundary'
      vy1=input('enter boundary condition on left boundary  --->  ')
%      write(1,*)'enter boundary condition on left boundary'
      vy2=input('enter boundary condition on right boundary  --->  ')
%      write(1,*)'enter boundary condition on right boundary'
      eps=input('enter required tollerance error  --->  ')
%      write(1,*)'enter required tollerance error'

%   open(1,file='out1',form='formatted')

% start calculation

      n1=n1x+1;
      n2=n1y+1;

      for i=1:n1
          for j=1:n2
            vk(i,j)=0.0;
          end
      end
vk
% set boundary conditions on upper, lower, left and right surfaces

      for i=1:n1
           vk(i,1)=vx1;
           vk(i,n2)=vx2;
      end

for j=1:n2
      vk(1,j)=vy1;
      vk(n1,j)=vy2;
end
vk
% start iterations

      n=(n1-2)*(n2-2);
      kk=0;
      vv=0.0;
      vv1=eps*1e6;
  while abs(vv-vv1)>eps   
      vv1=vv;
        vv=0.;
      for i=2:n1-1
          for j=n2-1:-1:2
            vk(i,j)=(vk(i,j-1)+vk(i,j+1)+vk(i-1,j)+vk(i+1,j))/4.0;
            vv=vv+vk(i,j);
          end
      end
      vv=vv/n;
      kk=kk+1;
      n=0;

      for i=2:n1-1
          for j=2:n2-1
            n=n+1;
            v(n)=vk(j,i);
          end
      end
%  181 continue
%      write(1,2)(k,v(k),k=1,n)
%  111 continue
%      if(abs(vv-vv1).gt.eps)go to 1000
% The following two statements will print the iteration number (kk) 
% followed by the result
% kk
% vk
  end
% The following two statements print the last iteration number (kk) after
% followed by the final result (the error criterion has been satisfied)
kk
vk
%     the error criterion has been met. the correct solution is in vk

% rewrite the two-dimensional vector vk into a one dimensiona
%     vector v which contains only the interior nodes.

      n=0;

      for i=2:n1-1
          for j=2:n2-1
            n=n+1;
            v(n)=vk(j,i);
          end
      end
%  180 continue
%
% write the solution vector
%
%      disp('solution:')
%      vk
%      write(1,2)(k,v(k),k=1,n)
%   1 format(1x,'number of iterations = ',i5,/)
%   2 format(3('   node:',i3,',  v=',f9.4))